/**
 * XXXX
 * Inserte aqu la descripcin del tipo.
 * Fecha de creacin: (03/06/08)
 */   
package com.ejie.p06b.pdf.xml;


import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;

import javax.servlet.http.HttpServletRequest;

import com.ejie.p06b.datatype.model.P06B20T00Datatype;
import com.ejie.p06b.datatype.model.P06B83T00Datatype;
import com.ejie.p06b.general.P06BConstantes;
import com.ejie.p06b.log.P06BLog;
import com.ejie.p06b.util.P06BParametros;
import com.ejie.p06b.util.P06BResources;
import com.ejie.p06b.xlnet.P06BPerfilUsuario;
import com.ejie.p06b.manager.P06BCorredoresManager;
import com.ejie.p06b.manager.P06BGeneralManager;


/**
 * Clase que representa el xml para el pdf de Test
 */
public class P06BCartasDECXML{
   
	public static String getXml(ArrayList listTest, HttpServletRequest request)
	throws Exception {
		P06BLog.send(2,"P06BCartasDECXML", "getXml(...)");
		
		String denomProv = "";
      	String denomMunic = "";

		//Obtener el idioma
		String idiomaUsu = null;
		P06BPerfilUsuario perfilUsuario = (P06BPerfilUsuario) request.getSession().getAttribute(P06BConstantes.P06B_VAR_PERFIL_USUARIO);
		if (perfilUsuario != null){
			P06BLog.send(2,"P06BCartasDECXML - getXml", "Existe objeto perfilUsuario");
			idiomaUsu = perfilUsuario.getIdIdioma();
		}else{
			P06BLog.send(2,"P06BCartasDECXML - getXml", "NOOOOOO Existe objeto perfilUsuario");
		}
		if (idiomaUsu == null || idiomaUsu.equals("") ){
			idiomaUsu = P06BConstantes.P06B_IDIOMA_ES; //"es"
		}
		P06BLog.send(2,"P06BCartasDECXML - getXml", "Idioma: "+idiomaUsu);
				
		HashMap datosMap = getDatos(listTest);
		ArrayList listRegistros = (ArrayList)datosMap.get("listTest");
		
		StringBuffer xml = new StringBuffer("");

		xml.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>");
		
		xml.append("<cartas>");
			xml.append("<ejercicio>");
				xml.append(datosMap.get("ejercicio"));
			xml.append("</ejercicio>");
			
			xml.append("<ejerAnterior>");
				xml.append(datosMap.get("ejerAnterior"));
			xml.append("</ejerAnterior>");
			
			xml.append("<fechaActual>");
				xml.append("<dia>");
					xml.append(datosMap.get("dia"));
				xml.append("</dia>");
				
				xml.append("<mes>");
					//Pasar el mes a texto
					//xml.append(((P06BResources)request.getSession().getAttribute(P06BConstantes.P06B_RES_SES_ETIQUETAS)).get("mes."+datosMap.get("mes")));
					xml.append(P06BParametros.getListado("mesES."+datosMap.get("mes")));
				xml.append("</mes>");
				xml.append("<mesEU>");
					xml.append(P06BParametros.getListado("mesEU."+datosMap.get("mes")));
				xml.append("</mesEU>");
				
				xml.append("<anyo>");
					xml.append(datosMap.get("anyo"));
				xml.append("</anyo>");
			xml.append("</fechaActual>");
			
			P06B83T00Datatype datosDireccion = null;
			datosDireccion = P06BCorredoresManager.getInstance().selectDatosDireccion();
			xml.append("<datosDireccion>");
			xml.append("<descDireccionEus>");
			xml.append(		datosDireccion.getDescDireccionEus());
			xml.append("</descDireccionEus>");
			xml.append("<descDireccionCas>");
			xml.append(		datosDireccion.getDescDireccionCas());
			xml.append("</descDireccionCas>");
			xml.append("<nombreCompleto>");
			xml.append(		datosDireccion.getNombre()+" "+datosDireccion.getApe1()+" "+datosDireccion.getApe2());
			xml.append("</nombreCompleto>");
			xml.append("<idFicheroUnico>");
			String sFicheroUnico = "";
			sFicheroUnico = ((Integer)(int)(Math.random()*10000)).toString();
			xml.append(		sFicheroUnico);
			xml.append("</idFicheroUnico>");
			xml.append("</datosDireccion>");
			
			byte[] imagenFirma = datosDireccion.getImagenFirma();
			
			File file = new File("/datos/p06b/file/images/firma"+sFicheroUnico+".gif");
//			File file = new File("/datos/p06b/file/images/firma.gif");
			if (file.exists()){
				file.delete();
			}

			InputStream is = new ByteArrayInputStream(imagenFirma);
            FileOutputStream fos = new FileOutputStream("/datos/p06b/file/images/firma"+sFicheroUnico+".gif");
//            FileOutputStream fos = new FileOutputStream("/datos/p06b/file/images/firma.gif");

			int b = 0;
			while ((b = is.read()) != -1)
			{
			  fos.write(b); 
			}
			fos.close();

			for(int i=0;i<listTest.size();i++){
				P06B20T00Datatype registro = (P06B20T00Datatype)listRegistros.get(i);
				xml.append("<mediador>");
					xml.append("<denominacion>");
						if( (P06BConstantes.P06B_CORREDORES_TIPOPER_FISICA.equals(registro.getClase()))
							|| (P06BConstantes.P06B_AGENTEVINCULADO_FISICA.equals(registro.getClase())) 
							|| (P06BConstantes.P06B_REASEGUROS_FISICA.equals(registro.getClase())) ){
							xml.append((((registro.getApe1()==null)?"":registro.getApe1()) +" "+ ((registro.getApe2()==null)?"":registro.getApe2()) +", "+ ((registro.getNombre()==null)?"":registro.getNombre())));
						}else{
							xml.append(((registro.getRazsoc()==null)?"":registro.getRazsoc()));
						}
					xml.append("</denominacion>");
					
					xml.append("<direccion>");
						xml.append((registro.getDomici()==null)?"":registro.getDomici());
					xml.append("</direccion>");
					
					xml.append("<codPostal>");
						xml.append((registro.getCodpst()==null)?"":registro.getCodpst());
					xml.append("</codPostal>");
					
					//Obtener la denominacion de la provincia y del municipio
					denomProv = "";
					if (registro.getCodpro()!=null && !registro.getCodpro().equals("")){
			      		denomProv = P06BGeneralManager.getInstance().obtenerNomProv(idiomaUsu,registro.getCodpro());
			      	}
			      	denomMunic = "";
			      	if (registro.getCodpro()!=null && !registro.getCodpro().equals("") && registro.getCodmun()!=null && !registro.getCodmun().equals("")){
			      		denomMunic = P06BGeneralManager.getInstance().obtenerNomMun(registro.getCodpro(),registro.getCodmun());	      		
			      	}
			      	
					xml.append("<municipio>");
						xml.append(denomMunic);
					xml.append("</municipio>");
					
					xml.append("<provincia>");
						xml.append(denomProv);
					xml.append("</provincia>");
				xml.append("</mediador>");
			}
					
		xml.append("</cartas>");
				
		//En la razon social de algunos mediadores est el smbolo &. Da el error:
		//"The entity name must immediately follow the '&' in the entity reference."
		//Sustituyendo el smbolo & por su codificacin, desaparece el error.
		return xml.toString().replaceAll("&","&amp;");
	}
	
	//Devolver un hashMap de elementos donde la clave = etiqueta en el xml
	private static HashMap getDatos(ArrayList listTest)
	throws Exception {
		P06BLog.send(2,"P06BCartasDECXML", "getDatos(...)");
		
		java.util.Date fechaHoy = new java.util.Date();
		String ejercicio = "";
		String ejerAnterior = "";
		String mes = "";
		String dia = "";
		try{
			SimpleDateFormat formatoAnyo = new SimpleDateFormat("yyyy");
	   		ejercicio = formatoAnyo.format(fechaHoy);
	   		SimpleDateFormat formatoMes = new SimpleDateFormat("M");
	   		mes = formatoMes.format(fechaHoy);	
	   		SimpleDateFormat formatoDia = new SimpleDateFormat("d");
	   		dia = formatoDia.format(fechaHoy);
		}catch(Exception e){
			P06BLog.send(2,"P06BCartasDECXML","Error obteniendo el ejercicio actual: " + e.toString());
		}
		
		ejerAnterior = String.valueOf(Integer.parseInt(ejercicio) - 1);
				
		HashMap datosMap = new HashMap();
		datosMap.put("ejercicio",ejercicio);
		datosMap.put("ejerAnterior",ejerAnterior);
		datosMap.put("anyo",ejercicio);
		datosMap.put("mes",mes);
		datosMap.put("dia",dia);
		datosMap.put("listTest",listTest);
		
		return datosMap;
	}
}